﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.UserModels;
    using Shared.EntityModels;
    using Shared.UserModels;
    using Hims.Shared.UserModels.Slots;
    
    /// <summary>
    /// The id proof Service interface.
    /// </summary>
    public interface IOTRoomAvailabilityService { 
        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
    Task<int> InsertAsync(OTRoomAvailabilityInsertModel model);

        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<OTRoomAvailabilityFilterModel>> FetchAllAsync(OTRoomAvailabilityFilterModel model);

        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<OTRoomAvailabilityFilterModel>> FetchAltAsync(OTRoomAvailabilityFetchModel model);
        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<OTRoomAvailabilityFilterModel>> FetchFilterMachineAvailabilityAsync(OTRoomAvailabilityFetchModel model);
        
        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateAsync(OTRoomAvailabilityInsertModel model);

       
        /// <summary>
        /// Activates the or deactivate ware house.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ActivateOrDeactivateTest(OTRoomAvailabilityInsertModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="ScanMachineAvailabilityId">
        /// The scan availability.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int? scanMachineAvailabilityId);
        /// <summary>
        /// Fetches the new slots.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<List<MultipleDays>> FetchSlotsForMultipleDays(SlotRequest model);
    }
}
